import numpy as np
import matplotlib.pyplot as plt

# Define the functions
def function(d):
    return (1 - np.exp(-(d**2)*5))**2

def function_1(d):
    return (1 - np.exp(-((d**2) * 2)))**2

def function_2(d):
    return (1 - np.exp(-(d**2) *1))**2

def function_3(d):
    return (1 - np.exp(-(d**2) / 2))**2

def function_4(d):
    return (1 - np.exp(-(d**2) / 5))**2



# Define the derivatives
def derivative(d):
    return 40*(1 - np.exp(-(d**2)*5)) * (d * np.exp(-(d**2)*5))/(1 + np.exp(-(d**2)*5))**3

def derivative_1(d):
    return 16*(1 - np.exp(-(d**2)*2)) * (d * np.exp(-(d**2)*2))/(1 + np.exp(-(d**2)*2))**3

def derivative_2(d):
    return 8*(1 - np.exp(-(d**2)*1)) * (d * np.exp(-d**2))/(1 + np.exp(-(d**2)))**3

def derivative_3(d):
    return 4*(1 - np.exp(-(d**2) / 2)) * (d * np.exp(-(d**2) / 2))/(1 + np.exp(-(d**2)/2))**3

def derivative_4(d):
    return (8/5)*(1 - np.exp(-(d**2) / 5)) * (d * np.exp(-(d**2) / 5))/(1 + np.exp(-(d**2)/5))**3

# Data for d
d_positive = np.linspace(0, 5, 400)

# Function values
f_values_positive = function(d_positive)
f1_values_positive = function_1(d_positive)
f2_values_positive = function_2(d_positive)
f3_values_positive = function_3(d_positive)
f4_values_positive = function_4(d_positive)
# Derivative values
df_values_positive = derivative(d_positive)
df1_values_positive = derivative_1(d_positive)
df2_values_positive = derivative_2(d_positive)
df3_values_positive = derivative_3(d_positive)
df4_values_positive = derivative_4(d_positive)
# Plotting the functions
plt.figure(figsize=(10, 5))


plt.plot(d_positive, f_values_positive, label='$D_2 (\psi (s_0, 0.2)|| \psi(s, 0.2))$', linestyle='--')
plt.plot(d_positive, f1_values_positive, label='$D_2 (\psi (s_0, 0.5)|| \psi(s, 0.5))$', linestyle=':')
plt.plot(d_positive, f2_values_positive, label='$D_2 (\psi (s_0, 1)|| \psi(s, 1))$', linestyle='-.')
plt.plot(d_positive, f3_values_positive, label='$D_2 (\psi (s_0, 2)|| \psi(s, 2))$', linestyle=':')
plt.plot(d_positive, f4_values_positive, label='$D_2 (\psi (s_0, 5)|| \psi(s, 5))$', linestyle='-.')

plt.title('Comparison of renyi divergence in embedded space $\psi(s, B) > 0$')
plt.xlabel('d(s_0, s)')
plt.ylabel('Function value')
plt.grid(True)
plt.legend()

plt.show()

# Plotting the derivatives
plt.figure(figsize=(10, 5))

plt.plot(d_positive, df_values_positive, label='Derivative of $D_{kl} (\~\psi_{0.2} (s_0)|| \~\psi_{0.2}(s))$', linestyle='-.')
plt.plot(d_positive, df1_values_positive, label='Derivative of$D_{kl} (\~\psi_{0.5} (s_0)|| \~\psi_{0.5}(s))$', linestyle='--')
plt.plot(d_positive, df2_values_positive, label='Derivative of $D_{kl} (\~\psi_{1} (s_0)|| \~\psi_1(s))$', linestyle=':')
plt.plot(d_positive, df3_values_positive, label='Derivative of $D_{kl} (\~\psi_2 (s_0)|| \~\psi_2(s))$', linestyle='--')
plt.plot(d_positive, df4_values_positive, label='Derivative of $D_{kl} (\~\psi_5 (s_0)|| \~\psi_5(s))$', linestyle=':')


plt.xlabel('$d(s_0, s)$', fontsize='large')
plt.ylabel('Derivative value', fontsize='large')
plt.grid(True)
plt.legend(fontsize='large')

plt.show()
